using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgSupplyInventoryCriteria
	/// </summary>
	public class DlgSupplyInventoryCriteria : gov.va.med.vbecs.GUI.VbecsBaseForm
	{

		#region Variables

		private BOL.SupplyInventoryReport _objSupplyReport;
		private System.Data.DataTable _dtSupplyReport;
		private bool _isLoading = false;
		private System.Collections.ArrayList _supplyTypes;
		private System.Collections.ArrayList _supplyTypeIds;

		#endregion

		#region Form Controls

		private System.Windows.Forms.RadioButton rdoUnsatisfactory;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.RadioButton rdoExpired;
		private System.Windows.Forms.RadioButton rdoInDate;
		private System.Windows.Forms.GroupBox grpReceivedDate;
		private System.Windows.Forms.DateTimePicker dtpReceivedAfter;
		private System.Windows.Forms.DateTimePicker dtpReceivedBefore;
		private System.Windows.Forms.CheckBox cbReceivedBefore;
		private System.Windows.Forms.CheckBox cbReceivedAfter;
		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.GroupBox grpExpirationDate;
		private System.Windows.Forms.DateTimePicker dtpExpireAfter;
		private System.Windows.Forms.DateTimePicker dtpExpireBefore;
		private System.Windows.Forms.CheckBox cbExpireAfter;
		private System.Windows.Forms.CheckBox cbExpireBefore;
		private System.Windows.Forms.GroupBox grpSupplyType;
		private System.Windows.Forms.Button btnSelectAll;
		private System.Windows.Forms.Button btnDeselectAll;
		private System.Windows.Forms.CheckedListBox lvSupplyType;
		private System.Windows.Forms.RadioButton rdoDateRange;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructors

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgSupplyInventoryCriteria()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			this._objSupplyReport = new BOL.SupplyInventoryReport();

			SetComponentProperties();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}


		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgSupplyInventoryCriteria));
			this.rdoUnsatisfactory = new System.Windows.Forms.RadioButton();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.rdoExpired = new System.Windows.Forms.RadioButton();
			this.rdoInDate = new System.Windows.Forms.RadioButton();
			this.grpSupplyType = new System.Windows.Forms.GroupBox();
			this.btnSelectAll = new System.Windows.Forms.Button();
			this.btnDeselectAll = new System.Windows.Forms.Button();
			this.lvSupplyType = new System.Windows.Forms.CheckedListBox();
			this.grpReceivedDate = new System.Windows.Forms.GroupBox();
			this.dtpReceivedAfter = new System.Windows.Forms.DateTimePicker();
			this.dtpReceivedBefore = new System.Windows.Forms.DateTimePicker();
			this.cbReceivedBefore = new System.Windows.Forms.CheckBox();
			this.cbReceivedAfter = new System.Windows.Forms.CheckBox();
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpExpirationDate = new System.Windows.Forms.GroupBox();
			this.dtpExpireAfter = new System.Windows.Forms.DateTimePicker();
			this.dtpExpireBefore = new System.Windows.Forms.DateTimePicker();
			this.cbExpireAfter = new System.Windows.Forms.CheckBox();
			this.cbExpireBefore = new System.Windows.Forms.CheckBox();
			this.rdoDateRange = new System.Windows.Forms.RadioButton();
			this.grpImage.SuspendLayout();
			this.grpSupplyType.SuspendLayout();
			this.grpReceivedDate.SuspendLayout();
			this.grpExpirationDate.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(456, 30);
			this.vbecsLogo1.TabIndex = 9;
			this.vbecsLogo1.Title = "Supply Inventory";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 261);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 11;
			// 
			// rdoUnsatisfactory
			// 
			this.rdoUnsatisfactory.AccessibleDescription = "unsatisfactory supplies";
			this.rdoUnsatisfactory.AccessibleName = "unsatisfactory supplies";
			this.rdoUnsatisfactory.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.rdoUnsatisfactory.Location = new System.Drawing.Point(288, 56);
			this.rdoUnsatisfactory.Name = "rdoUnsatisfactory";
			this.rdoUnsatisfactory.Size = new System.Drawing.Size(156, 20);
			this.rdoUnsatisfactory.TabIndex = 2;
			this.rdoUnsatisfactory.Text = "&Unsatisfactory Supplies";
			this.rdoUnsatisfactory.CheckedChanged += new System.EventHandler(this.InventoryFilter_CheckChanged);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.BackColor = System.Drawing.SystemColors.Control;
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 208);
			this.grpImage.TabIndex = 10;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 16);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(45, 44);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picImage.TabIndex = 38;
			this.picImage.TabStop = false;
			// 
			// rdoExpired
			// 
			this.rdoExpired.AccessibleDescription = "expired supplies";
			this.rdoExpired.AccessibleName = "expired supplies";
			this.rdoExpired.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.rdoExpired.Location = new System.Drawing.Point(288, 76);
			this.rdoExpired.Name = "rdoExpired";
			this.rdoExpired.Size = new System.Drawing.Size(148, 20);
			this.rdoExpired.TabIndex = 3;
			this.rdoExpired.Text = "E&xpired Supplies";
			this.rdoExpired.CheckedChanged += new System.EventHandler(this.InventoryFilter_CheckChanged);
			// 
			// rdoInDate
			// 
			this.rdoInDate.AccessibleDescription = "in date supplies";
			this.rdoInDate.AccessibleName = "in date supplies";
			this.rdoInDate.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.rdoInDate.Checked = true;
			this.rdoInDate.Location = new System.Drawing.Point(288, 36);
			this.rdoInDate.Name = "rdoInDate";
			this.rdoInDate.Size = new System.Drawing.Size(148, 20);
			this.rdoInDate.TabIndex = 1;
			this.rdoInDate.TabStop = true;
			this.rdoInDate.Text = "&In-Date Supplies";
			this.rdoInDate.CheckedChanged += new System.EventHandler(this.InventoryFilter_CheckChanged);
			// 
			// grpSupplyType
			// 
			this.grpSupplyType.AccessibleDescription = "Supply Type";
			this.grpSupplyType.AccessibleName = "Supply Type";
			this.grpSupplyType.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSupplyType.Controls.Add(this.btnSelectAll);
			this.grpSupplyType.Controls.Add(this.btnDeselectAll);
			this.grpSupplyType.Controls.Add(this.lvSupplyType);
			this.grpSupplyType.Location = new System.Drawing.Point(60, 32);
			this.grpSupplyType.Name = "grpSupplyType";
			this.grpSupplyType.Size = new System.Drawing.Size(216, 208);
			this.grpSupplyType.TabIndex = 0;
			this.grpSupplyType.TabStop = false;
			this.grpSupplyType.Text = "Supply Type*";
			// 
			// btnSelectAll
			// 
			this.btnSelectAll.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSelectAll.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnSelectAll.Image = ((System.Drawing.Image)(resources.GetObject("btnSelectAll.Image")));
			this.btnSelectAll.Location = new System.Drawing.Point(192, 0);
			this.btnSelectAll.Name = "btnSelectAll";
			this.btnSelectAll.Size = new System.Drawing.Size(16, 16);
			this.btnSelectAll.TabIndex = 2;
			this.btnSelectAll.Click += new System.EventHandler(this.btnSelectAll_Click);
			// 
			// btnDeselectAll
			// 
			this.btnDeselectAll.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnDeselectAll.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnDeselectAll.Image = ((System.Drawing.Image)(resources.GetObject("btnDeselectAll.Image")));
			this.btnDeselectAll.Location = new System.Drawing.Point(176, 0);
			this.btnDeselectAll.Name = "btnDeselectAll";
			this.btnDeselectAll.Size = new System.Drawing.Size(16, 16);
			this.btnDeselectAll.TabIndex = 1;
			this.btnDeselectAll.Click += new System.EventHandler(this.btnDeselectAll_Click);
			// 
			// lvSupplyType
			// 
			this.lvSupplyType.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvSupplyType.CheckOnClick = true;
			this.lvSupplyType.Items.AddRange(new object[] {
															  "Supply Type 1",
															  "Supply Type 2"});
			this.lvSupplyType.Location = new System.Drawing.Point(8, 16);
			this.lvSupplyType.Name = "lvSupplyType";
			this.lvSupplyType.Size = new System.Drawing.Size(200, 184);
			this.lvSupplyType.TabIndex = 0;
			this.lvSupplyType.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvSupplyType_ItemCheck);
			// 
			// grpReceivedDate
			// 
			this.grpReceivedDate.AccessibleDescription = "received date";
			this.grpReceivedDate.AccessibleName = "received date";
			this.grpReceivedDate.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.grpReceivedDate.Controls.Add(this.dtpReceivedAfter);
			this.grpReceivedDate.Controls.Add(this.dtpReceivedBefore);
			this.grpReceivedDate.Controls.Add(this.cbReceivedBefore);
			this.grpReceivedDate.Controls.Add(this.cbReceivedAfter);
			this.grpReceivedDate.Location = new System.Drawing.Point(280, 172);
			this.grpReceivedDate.Name = "grpReceivedDate";
			this.grpReceivedDate.Size = new System.Drawing.Size(172, 68);
			this.grpReceivedDate.TabIndex = 6;
			this.grpReceivedDate.TabStop = false;
			this.grpReceivedDate.Text = "Received Date";
			// 
			// dtpReceivedAfter
			// 
			this.dtpReceivedAfter.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpReceivedAfter.CustomFormat = "MM/dd/yyyy";
			this.dtpReceivedAfter.Enabled = false;
			this.dtpReceivedAfter.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpReceivedAfter.Location = new System.Drawing.Point(76, 40);
			this.dtpReceivedAfter.Name = "dtpReceivedAfter";
			this.dtpReceivedAfter.Size = new System.Drawing.Size(88, 20);
			this.dtpReceivedAfter.TabIndex = 3;
			this.dtpReceivedAfter.ValueChanged += new System.EventHandler(this.dtpReceivedAfter_ValueChanged);
			// 
			// dtpReceivedBefore
			// 
			this.dtpReceivedBefore.AccessibleDescription = "received before date";
			this.dtpReceivedBefore.AccessibleName = "received before date";
			this.dtpReceivedBefore.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpReceivedBefore.CustomFormat = "MM/dd/yyyy";
			this.dtpReceivedBefore.Enabled = false;
			this.dtpReceivedBefore.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpReceivedBefore.Location = new System.Drawing.Point(76, 16);
			this.dtpReceivedBefore.Name = "dtpReceivedBefore";
			this.dtpReceivedBefore.Size = new System.Drawing.Size(88, 20);
			this.dtpReceivedBefore.TabIndex = 1;
			this.dtpReceivedBefore.ValueChanged += new System.EventHandler(this.dtpReceivedBefore_ValueChanged);
			// 
			// cbReceivedBefore
			// 
			this.cbReceivedBefore.AccessibleDescription = "received before";
			this.cbReceivedBefore.AccessibleName = "received before";
			this.cbReceivedBefore.Location = new System.Drawing.Point(24, 16);
			this.cbReceivedBefore.Name = "cbReceivedBefore";
			this.cbReceivedBefore.Size = new System.Drawing.Size(60, 20);
			this.cbReceivedBefore.TabIndex = 0;
			this.cbReceivedBefore.Text = "B&efore";
			this.cbReceivedBefore.CheckedChanged += new System.EventHandler(this.cbReceivedBefore_CheckedChanged);
			// 
			// cbReceivedAfter
			// 
			this.cbReceivedAfter.AccessibleDescription = "received after date";
			this.cbReceivedAfter.AccessibleName = "received after date";
			this.cbReceivedAfter.Location = new System.Drawing.Point(24, 40);
			this.cbReceivedAfter.Name = "cbReceivedAfter";
			this.cbReceivedAfter.Size = new System.Drawing.Size(60, 20);
			this.cbReceivedAfter.TabIndex = 2;
			this.cbReceivedAfter.Text = "A&fter";
			this.cbReceivedAfter.CheckedChanged += new System.EventHandler(this.cbReceivedAfter_CheckedChanged);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(376, 244);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 8;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(296, 244);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 7;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// grpExpirationDate
			// 
			this.grpExpirationDate.AccessibleDescription = "expired date range";
			this.grpExpirationDate.AccessibleName = "expired date range";
			this.grpExpirationDate.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.grpExpirationDate.Controls.Add(this.dtpExpireAfter);
			this.grpExpirationDate.Controls.Add(this.dtpExpireBefore);
			this.grpExpirationDate.Controls.Add(this.cbExpireAfter);
			this.grpExpirationDate.Controls.Add(this.cbExpireBefore);
			this.grpExpirationDate.Location = new System.Drawing.Point(280, 100);
			this.grpExpirationDate.Name = "grpExpirationDate";
			this.grpExpirationDate.Size = new System.Drawing.Size(172, 68);
			this.grpExpirationDate.TabIndex = 5;
			this.grpExpirationDate.TabStop = false;
			// 
			// dtpExpireAfter
			// 
			this.dtpExpireAfter.AccessibleDescription = "expire after date";
			this.dtpExpireAfter.AccessibleName = "expire after date";
			this.dtpExpireAfter.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpExpireAfter.CustomFormat = "MM/dd/yyyy";
			this.dtpExpireAfter.Enabled = false;
			this.dtpExpireAfter.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpExpireAfter.Location = new System.Drawing.Point(76, 44);
			this.dtpExpireAfter.Name = "dtpExpireAfter";
			this.dtpExpireAfter.Size = new System.Drawing.Size(88, 20);
			this.dtpExpireAfter.TabIndex = 3;
			this.dtpExpireAfter.ValueChanged += new System.EventHandler(this.dtpExpireAfter_ValueChanged);
			// 
			// dtpExpireBefore
			// 
			this.dtpExpireBefore.AccessibleDescription = "expire before date";
			this.dtpExpireBefore.AccessibleName = "expire before date";
			this.dtpExpireBefore.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpExpireBefore.CustomFormat = "MM/dd/yyyy";
			this.dtpExpireBefore.Enabled = false;
			this.dtpExpireBefore.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpExpireBefore.Location = new System.Drawing.Point(76, 20);
			this.dtpExpireBefore.Name = "dtpExpireBefore";
			this.dtpExpireBefore.Size = new System.Drawing.Size(88, 20);
			this.dtpExpireBefore.TabIndex = 1;
			this.dtpExpireBefore.ValueChanged += new System.EventHandler(this.dtpExpireBefore_ValueChanged);
			// 
			// cbExpireAfter
			// 
			this.cbExpireAfter.AccessibleDescription = "expire after";
			this.cbExpireAfter.AccessibleName = "expire after";
			this.cbExpireAfter.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.cbExpireAfter.Location = new System.Drawing.Point(24, 44);
			this.cbExpireAfter.Name = "cbExpireAfter";
			this.cbExpireAfter.Size = new System.Drawing.Size(60, 16);
			this.cbExpireAfter.TabIndex = 2;
			this.cbExpireAfter.Text = "&After";
			this.cbExpireAfter.CheckedChanged += new System.EventHandler(this.cbExpireAfter_CheckedChanged);
			// 
			// cbExpireBefore
			// 
			this.cbExpireBefore.AccessibleDescription = "expire before";
			this.cbExpireBefore.AccessibleName = "expire before";
			this.cbExpireBefore.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.cbExpireBefore.Location = new System.Drawing.Point(24, 20);
			this.cbExpireBefore.Name = "cbExpireBefore";
			this.cbExpireBefore.Size = new System.Drawing.Size(60, 16);
			this.cbExpireBefore.TabIndex = 0;
			this.cbExpireBefore.Text = "&Before";
			this.cbExpireBefore.CheckedChanged += new System.EventHandler(this.cbExpireBefore_CheckedChanged);
			// 
			// rdoDateRange
			// 
			this.rdoDateRange.AccessibleDescription = "expired date range";
			this.rdoDateRange.AccessibleName = "expired date range";
			this.rdoDateRange.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.rdoDateRange.Location = new System.Drawing.Point(288, 96);
			this.rdoDateRange.Name = "rdoDateRange";
			this.rdoDateRange.Size = new System.Drawing.Size(148, 20);
			this.rdoDateRange.TabIndex = 4;
			this.rdoDateRange.Text = "Expiration &Date Range";
			this.rdoDateRange.CheckedChanged += new System.EventHandler(this.InventoryFilter_CheckChanged);
			// 
			// DlgSupplyInventoryCriteria
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(456, 277);
			this.Controls.Add(this.rdoDateRange);
			this.Controls.Add(this.rdoUnsatisfactory);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.rdoExpired);
			this.Controls.Add(this.rdoInDate);
			this.Controls.Add(this.grpSupplyType);
			this.Controls.Add(this.grpReceivedDate);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpExpirationDate);
			this.hlphelpChm.SetHelpKeyword(this, "View___Print_Supply_Inventory_.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(464, 304);
			this.Name = "DlgSupplyInventoryCriteria";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Supply Inventory";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgSupplyInventoryCriteria_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpExpirationDate, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpReceivedDate, 0);
			this.Controls.SetChildIndex(this.grpSupplyType, 0);
			this.Controls.SetChildIndex(this.rdoInDate, 0);
			this.Controls.SetChildIndex(this.rdoExpired, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.rdoUnsatisfactory, 0);
			this.Controls.SetChildIndex(this.rdoDateRange, 0);
			this.grpImage.ResumeLayout(false);
			this.grpSupplyType.ResumeLayout(false);
			this.grpReceivedDate.ResumeLayout(false);
			this.grpExpirationDate.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties
		/// <summary>
		/// Gets VBECS report object
		/// </summary>
		public BOL.VbecsReport SupplyInventoryReport
		{
			get
			{
				return this._objSupplyReport;
			}
		}

		/// <summary>
		/// Gets report data
		/// </summary>
		public System.Data.DataTable SupplyInventoryReportData
		{
			get
			{
				return this._dtSupplyReport;
			}
		}

		#endregion

		#region Method

		private void SetComponentProperties()
		{
			this._isLoading = true;

			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC081.DlgSupplyInventoryCriteria());
			//
			this.btnOK.Text = "&OK";
			//
			//set custom date and time format
			this.dtpExpireAfter.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpExpireBefore.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpReceivedAfter.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpReceivedBefore.CustomFormat = Common.VBECSDateTime.DateFormat;
			//
			//set current date value based on the division time zone
			System.DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpExpireAfter.Value = currentDate;
			this.dtpExpireBefore.Value = currentDate;
			this.dtpReceivedAfter.Value = currentDate;
			this.dtpReceivedBefore.Value = currentDate;

			this.grpExpirationDate.Enabled = false;

			this.PopulateSupplyTypes();

			this.ttToolTip.SetToolTip(this.btnOK, Common.StrRes.Tooltips.UC081.CriteriaOkButton().ResString);
			this.ttToolTip.SetToolTip(this.btnCancel, Common.StrRes.Tooltips.Common.Cancel().ResString);
			this.ttToolTip.SetToolTip(this.lvSupplyType, Common.StrRes.Tooltips.UC081.CriteriaSupplyListView().ResString);
			this.ttToolTip.SetToolTip(this.btnSelectAll, Common.StrRes.Tooltips.Common.SelectAll().ResString);
			this.ttToolTip.SetToolTip(this.btnDeselectAll, Common.StrRes.Tooltips.Common.DeselectAll().ResString);

			//Set our default
			this.rdoInDate.Checked = true;

			this._isLoading = false;
		}


		private void PopulateSupplyTypes()
		{
			//The key should be the int, the value should be the string
			System.Collections.ArrayList[] supplyData = BOL.Supply.GetSupplyTypeList();

			this._supplyTypeIds = supplyData[0];
			this._supplyTypes = supplyData[1];
			
			this.lvSupplyType.Items.Clear();

			for (int ndx=0; ndx < this._supplyTypeIds.Count; ndx++)
			{
				this.lvSupplyType.Items.Add(this._supplyTypes[ndx].ToString());
			}
		}


		#endregion

		private void InventoryFilter_CheckChanged(object sender, System.EventArgs e)
		{
			bool enableDateRangeCtls = false;

			if (rdoInDate.Checked == true)
				this._objSupplyReport.InventoryFilter = Common.SupplyInventoryReportFilter.InDate;
        
			if (rdoUnsatisfactory.Checked == true)
				this._objSupplyReport.InventoryFilter = Common.SupplyInventoryReportFilter.Unsatisfactory;

			if (rdoExpired.Checked == true)
				this._objSupplyReport.InventoryFilter = Common.SupplyInventoryReportFilter.Expired;

			if (rdoDateRange.Checked == true)
			{
				enableDateRangeCtls = true;
				this._objSupplyReport.InventoryFilter = Common.SupplyInventoryReportFilter.ExpiredWithDateRange;
			}

			//Set the controls up
			this.grpExpirationDate.Enabled = enableDateRangeCtls;
		}

		/// <summary>
		/// If they check the box, set the date, else, set the max value to indicate null
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbExpireBefore_CheckedChanged(object sender, System.EventArgs e)
		{
			this.dtpExpireBefore.Enabled = (this.cbExpireBefore.Checked);
			if (cbExpireBefore.Checked == true)
			{
				this._objSupplyReport.ExpirationEndDate = this.dtpExpireBefore.Value;
			}
			else
			{
				this._objSupplyReport.ExpirationEndDate = System.DateTime.MaxValue;
			}
		}

		/// <summary>
		/// If they check the box, set the date, else, set the min value to indicate null
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbExpireAfter_CheckedChanged(object sender, System.EventArgs e)
		{
			this.dtpExpireAfter.Enabled = (this.cbExpireAfter.Checked);
			if (cbExpireAfter.Checked == true)
			{
				this._objSupplyReport.ExpirationStartDate = this.dtpExpireAfter.Value;
			}
			else
			{
				this._objSupplyReport.ExpirationStartDate = System.DateTime.MinValue;
			}
		}

		/// <summary>
		/// If they check the box, set the date, else, set the max value to indicate null
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbReceivedBefore_CheckedChanged(object sender, System.EventArgs e)
		{
			this.dtpReceivedBefore.Enabled = (cbReceivedBefore.Checked);

			if (cbReceivedBefore.Checked == true)
			{
				this._objSupplyReport.ReceiptEndDate = this.dtpReceivedBefore.Value;
			}
			else
			{
				this._objSupplyReport.ReceiptEndDate = System.DateTime.MaxValue;
			}
		}

		/// <summary>
		/// If they check the box, set the date, else, set the min value to indicate null
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbReceivedAfter_CheckedChanged(object sender, System.EventArgs e)
		{
			this.dtpReceivedAfter.Enabled = (cbReceivedAfter.Checked);

			if (cbReceivedAfter.Checked == true)
			{
				this._objSupplyReport.ReceiptStartDate = this.dtpReceivedAfter.Value;
			}
			else
			{
				this._objSupplyReport.ReceiptStartDate = System.DateTime.MinValue;
			}
		}

		private void dtpExpireBefore_ValueChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				this._objSupplyReport.ExpirationEndDate = this.dtpExpireBefore.Value;
			}
		}

		private void dtpExpireAfter_ValueChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				this._objSupplyReport.ExpirationStartDate = this.dtpExpireAfter.Value;
			}
		}

		private void dtpReceivedBefore_ValueChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				this._objSupplyReport.ReceiptEndDate = this.dtpReceivedBefore.Value;
			}
		}

		private void dtpReceivedAfter_ValueChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				this._objSupplyReport.ReceiptStartDate = this.dtpReceivedAfter.Value;
			}
		}

		private void btnDeselectAll_Click(object sender, System.EventArgs e)
		{
			for(int ndx=0; ndx < this.lvSupplyType.Items.Count; ndx++)
			{
				this.lvSupplyType.SetItemCheckState(ndx, CheckState.Unchecked);
			}

		}

		private void btnSelectAll_Click(object sender, System.EventArgs e)
		{
			for(int ndx=0; ndx < this.lvSupplyType.Items.Count; ndx++)
			{
				this.lvSupplyType.SetItemCheckState(ndx, CheckState.Checked);
			}
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			using( WaitCursor _cursor = new WaitCursor() )
			{
				//Grab all the SupplyTypes first
				this._objSupplyReport.SupplyTypeIds.Clear();
				for (int ndx=0; ndx < this.lvSupplyType.Items.Count; ndx++)
				{
					if (this.lvSupplyType.GetItemCheckState(ndx) == CheckState.Checked)
					{
						this._objSupplyReport.SupplyTypeIds.Add(this._supplyTypeIds[ndx].ToString());
					}
				}

				this._dtSupplyReport = this._objSupplyReport.GetSupplyInventoryReport();

				if(this._dtSupplyReport.Rows.Count == 0)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.NoInfoReturned());
					return;
				}
				//Some BR to check the page count---
				else if((this._dtSupplyReport.Rows.Count/20) >= 50) //assume 20 records per page???
				{
					DialogResult promptContinue = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC049.PageCountAlert());
					if( promptContinue != DialogResult.Yes )
					{
						return;
					}
					else
					{
						//Alert user that building report may take a few minutes
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.Warning());
					}
				}
			}

			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void lvSupplyType_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			bool enableOK = false;

			if (e.NewValue == System.Windows.Forms.CheckState.Checked)
			{
				enableOK = true;
			}
			else
			{
				if (this.lvSupplyType.CheckedItems.Count > 1)
				{
					enableOK = true;
				}
			}

			this.btnOK.EnabledButton = enableOK; // **** 508 Compliance *** : changed to EnabledButton
			if (enableOK)
				this.ttToolTip.SetToolTip(this.btnOK, Common.StrRes.Tooltips.Common.OKToProceed().ResString);
			else
				this.ttToolTip.SetToolTip(this.btnOK, Common.StrRes.Tooltips.UC081.CriteriaOkButton().ResString);
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgSupplyInventoryCriteria_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			if ( !this.btnOK.EnabledButton )
			{
				this.SpeakMessage( this.ttToolTip.GetToolTip(this.btnOK) );
			}
		}
	}
}

